/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.admin.property.integrator;

import filenet.vw.api.VWSystemConfiguration;
import filenet.vw.base.VWDebug;
import filenet.vw.base.VWLogger;
import filenet.vw.toolkit.admin.property.integrator.VWConfigurationModuleRegistrationPanel;
import filenet.vw.toolkit.admin.property.integrator.VWLibraryRegistrationPanel;
import filenet.vw.toolkit.admin.resources.VWResource;
import filenet.vw.toolkit.utils.VWHelp;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.dialog.VWMessageDialog;
import filenet.vw.toolkit.utils.dialog.VWModalDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class VWComponentRegistrationDialog
extends VWModalDialog
implements ActionListener {
    private VWConfigurationModuleRegistrationPanel m_vwConfigurationModuleRegistrationPanel = null;
    private VWLibraryRegistrationPanel m_vwLibraryRegistrationPanel = null;
    private JButton m_okButton = null;
    private JButton m_cancelButton = null;
    private JButton m_helpButton = null;
    private int m_nRetStatus = 1;

    public VWComponentRegistrationDialog(Frame parentFrame, VWSystemConfiguration vwSystemConfiguration) {
        super(parentFrame);
        try {
            this.setTitle(VWResource.ComponentRegistrationDialogTitle);
            Dimension dim = VWStringUtils.stringToDimension("555,335");
            if (dim == null) {
                dim = new Dimension(500, 300);
            }
            this.setSize(dim.width, dim.height);
            this.setVisible(false);
            JTabbedPane tabbedPane = new JTabbedPane();
            this.m_vwLibraryRegistrationPanel = new VWLibraryRegistrationPanel(parentFrame, vwSystemConfiguration);
            tabbedPane.add(VWResource.JarFileLocations, this.m_vwLibraryRegistrationPanel);
            this.m_vwConfigurationModuleRegistrationPanel = new VWConfigurationModuleRegistrationPanel(this, vwSystemConfiguration, this.m_vwLibraryRegistrationPanel);
            this.m_vwLibraryRegistrationPanel.addRegistrationActionListener(this.m_vwConfigurationModuleRegistrationPanel);
            tabbedPane.add(VWResource.ConfigurationModuleClasses, this.m_vwConfigurationModuleRegistrationPanel);
            this.getContentPane().setLayout(new BorderLayout(6, 6));
            this.getContentPane().add((Component)tabbedPane, "Center");
            this.getContentPane().add((Component)this.getButtonPanel(), "Last");
            this.setLocationRelativeTo(parentFrame);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public static void main(String[] argv) {
        try {
            VWDebug.init(VWLogger.ERROR);
            VWComponentRegistrationDialog dlg = new VWComponentRegistrationDialog(new Frame("Dummy"), null);
            dlg.setVisible(true);
            System.exit(0);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            System.exit(1);
        }
    }

    public int getStatus() {
        return this.m_nRetStatus;
    }

    public boolean isModified() {
        return this.m_vwConfigurationModuleRegistrationPanel.isModified() || this.m_vwLibraryRegistrationPanel.isModified();
    }

    public void releaseResources() {
        if (this.m_vwConfigurationModuleRegistrationPanel != null) {
            this.m_vwConfigurationModuleRegistrationPanel.releaseResources();
            this.m_vwConfigurationModuleRegistrationPanel = null;
        }
        if (this.m_vwLibraryRegistrationPanel != null) {
            this.m_vwLibraryRegistrationPanel.releaseResources();
            this.m_vwLibraryRegistrationPanel = null;
        }
        if (this.m_okButton != null) {
            this.m_okButton.removeActionListener(this);
            this.m_okButton.removeAll();
            this.m_okButton = null;
        }
        if (this.m_cancelButton != null) {
            this.m_cancelButton.removeActionListener(this);
            this.m_cancelButton.removeAll();
            this.m_cancelButton = null;
        }
        if (this.m_helpButton != null) {
            this.m_helpButton.removeActionListener(this);
            this.m_helpButton.removeAll();
            this.m_helpButton = null;
        }
        this.removeAll();
    }

    public void actionPerformed(ActionEvent event) {
        Object obj = event.getSource();
        if (obj.equals(this.m_okButton)) {
            if (!(this.m_vwConfigurationModuleRegistrationPanel.validateComponentList() && this.m_vwLibraryRegistrationPanel.validateComponentList() || VWMessageDialog.showConfirmDialog(this, VWResource.ComponentRegistrationWarning1) == 1)) {
                return;
            }
            if (!this.m_vwConfigurationModuleRegistrationPanel.save()) {
                return;
            }
            if (!this.m_vwLibraryRegistrationPanel.save()) {
                return;
            }
            this.m_nRetStatus = 0;
            this.setVisible(false);
        } else if (obj.equals(this.m_cancelButton)) {
            this.m_nRetStatus = 1;
            this.setVisible(false);
        } else if (obj.equals(this.m_helpButton)) {
            VWHelp.displayPage(VWHelp.Help_Process_Config + "bpfc052.htm");
        }
    }

    private JPanel getButtonPanel() {
        try {
            JPanel panel = new JPanel(new FlowLayout());
            this.m_okButton = new JButton(VWResource.OK);
            panel.add(this.m_okButton);
            this.m_okButton.addActionListener(this);
            this.m_cancelButton = new JButton(VWResource.Cancel);
            panel.add(this.m_cancelButton);
            this.m_cancelButton.addActionListener(this);
            this.m_helpButton = new JButton(VWResource.Ellipse.toString(VWResource.Help));
            panel.add(this.m_helpButton);
            this.m_helpButton.addActionListener(this);
            return panel;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }
}

